#ifndef MY_BTXXX_H
#define MY_BTXXX_H

#include "ccrypt.h"
#include "btmap.h"

#define BT848	0x0350109e
#define BT849	0x0351109e
#define BT878	0x036e109e
#define BT879	0x036f109e

#define XT0FREQ		28636360
#define XT1FREQ		35468950

#define VIDEO_SVIDEO 		1
#define VIDEO_TUNER 		2
#define VIDEO_COMPOSITE 	3

#define AUDIO_TUNER 		0
#define AUDIO_EXTAUDIO 	1
#define AUDIO_CDROM		2
#define AUDIO_MUTE	 	3

// getCrystal(), setCrystal()
#define XT0 				1
#define XT1 				2
#define XT_AUTOSELECT	3

#define VIDEOFORMAT_AUTODETECT	0
#define VIDEOFORMAT_NTSC			1
#define VIDEOFORMAT_NTSC_JAPAN	2
#define VIDEOFORMAT_PAL_BDGHI		3
#define VIDEOFORMAT_PAL_M			4
#define VIDEOFORMAT_PAL_N			5
#define VIDEOFORMAT_SECAM			6
#define VIDEOFORMAT_PAL_NCOMB		7

#define CORINGLEVEL_NONE	0
#define CORINGLEVEL_8		1
#define CORINGLEVEL_16		2
#define CORINGLEVEL_32		3

#define COLORFORMAT_RGB32		0
#define COLORFORMAT_RGB24		1
#define COLORFORMAT_RGB16		2
#define COLORFORMAT_RGB15		3
#define COLORFORMAT_YUY			4
#define COLORFORMAT_BTYUV		5
#define COLORFORMAT_Y8			6
#define COLORFORMAT_RGB8		7
#define COLORFORMAT_YCrCb422	8
#define COLORFORMAT_YCrCb411	9
#define COLORFORMAT_Raw8X		14

#define RISC_IRQ			0x1000000	// trigger IRQ
#define RISC_SOL			0x4000000	// start of scanline
#define RISC_EOL			0x8000000	// end of scanline
#define RISC_RESYNC		0x0008000	// resync
#define RISC_SC_RESYNC	1
#define RISC_SC_VRE		4				// start of even field
#define RISC_SC_VRO		0xC			// start of odd field
#define RISC_SC_FM1		6				// packed data
#define RISC_SC_FM3		0xE			// planar data
#define RISC_WRITE( flags, count )		(0x10000000 | flags | count)
#define RISC_SKIP( flags, count )		(0x20000000 | flags | count)
#define RISC_WRITEC( flags, count )		(0x50000000 | flags | count)
#define RISC_JUMP( flags )					(0x70000000 | flags )
#define RISC_SYNC( flags, code )			(0x80000000 | flags | code)
#define RISC_WRITE123( flags, count1)	(0x90000000 | flags | count1)
#define RISC_SKIP123( flags, count1 )	(0xA0000000 | flags | count1)
#define RISC_WRITE1S23( flags, count )	(0xB0000000 | flags | count)
#define RISC_COUNT23( count2, count3 )	((count3 << 12) | count2)

#define HORIZFILTER_AUTOFORMAT	0
#define HORIZFILTER_CIF				1
#define HORIZFILTER_QCIF			2
#define HORIZFILTER_ICON		 	3


#define REMOTE_0           0
#define REMOTE_1           4
#define REMOTE_2           8
#define REMOTE_3           12
#define REMOTE_4           16
#define REMOTE_5           20
#define REMOTE_6           24
#define REMOTE_7           28
#define REMOTE_8           32
#define REMOTE_9           36
#define REMOTE_RADIO       48
#define REMOTE_MUTE        52
#define REMOTE_TV          60
#define REMOTE_VOL_PLUS    64
#define REMOTE_VOL_MINUS   68
#define REMOTE_RESERVED    120
#define REMOTE_CHAN_PLUS   128
#define REMOTE_CHAN_MINUS  132
#define REMOTE_SOURCE      136
#define REMOTE_MINIMIZE    152
#define REMOTE_FULL_SCREEN 184



class BTxxx {
	public:
   	BTxxx(void);
      ~BTxxx(void);

      int getType(void) const { return(_type); }  // 0 = not found
      const char* getTypeName(void);
      void* getAddress(void) const { return(_address); }

		int getVideoSource(void) { return(_address->muxsel); }
		int getVideoFormat(void){ return(_address->format); }
		int getCrystal(void) { return(_address->xtsel); }
		int getAGCDelay(void) {	return(_address->adelay); }
		int getBurstDelay(void) { return(_address->bdelay); }
      int getPllFrequency(void);
		int isPllEnabled(void) { return(_address->tgcki); }
		int getVerticalTotal(void)
      {
			return( (_address->vtotal_lo | (_address->vtotal_hi << 8)) + 1 );
		}
		int getTest(void) { return(_address->test); }
		bool isCrystal0(void) {	return(_address->csel); }
		bool is525Lines(void) { return(_address->numl); }
		bool isDevHLock(void) {	return(_address->hloc); }
		bool isVideoPresent(void) { return(_address->pres); }
		bool isPowerDown(void) { return(_address->clk_sleep == 1); }
		bool isAnalogThresholdLow(void) { return(_address->sync_t); }
		bool isComponentVideo(void) { return(_address->o_comp); }

    	void setVideoSource(int video_type) { _address->muxsel = video_type; }
		void setVideoFormat(int video_format) { _address->format = video_format; }
      void setCrystal(int xtal) { _address->xtsel = xtal; }
      void setAGCDelay(int data) { _address->adelay = data; }
      void setBurstDelay(int data) { _address->bdelay = data; }
      void setPllFrequency(int data);
      void setPllEnabled(int data) { _address->tgcki = data; }
      void setVerticalTotal(int data);
      void setTest(int data) { _address->test = data; }
      void setPowerDown(int data) { _address->clk_sleep = data; }
      void softwareReset(void) { _address->sreset = 0; }
      void setAnalogThresholdLow(int data) { _address->sync_t = data; }
      void setComponentVideo(int data)
      {
      	_address->e_comp = _address->o_comp = data;
      }

		int getBrightness(void); 		// brightness level, 0..255
		int getContrast(void);			// contrast, 0..511
		int getSaturation(void); 		// saturation, 0..511
		int getHue(void);					// hue, 0..255
		void setBrightness(int d);
		void setContrast(int d);
		void setSaturation(int d);
		void setHue(int d);

		bool isCaptureOddEnabled(void) {	return(_address->capture_odd); }
		bool isCaptureEvenEnabled(void) { return(_address->capture_even); }
		bool isCaptureVBIOddEnabled(void) {	return(_address->capture_vbi_odd); }
		bool isCaptureVBIEvenEnabled(void) { return(_address->capture_vbi_even);}
		int isCaptureEnabled(void)
      	{	return(_address->capture_odd | _address->capture_even); }
		int isCaptureVBIEnabled(void)
	      { return(_address->capture_vbi_odd | _address->capture_vbi_even); }
		bool isFifoEnabled(void) {	return(_address->fifo_enable); }
		bool isRiscEnabled(void) {	return(_address->risc_enable); }
		bool isDecodeEvenField(void) { return(_address->evenfield); }
		bool isDropFields(void) { return(_address->dec_field); }
		bool isDropEvenField(void) { return(_address->dec_fieldalign); }
		int getDropRate(void) { return(_address->dec_rate); }
		int getFieldCount(void) { return(_address->fcntr); }
		void setCaptureOddEnabled(bool data) { _address->capture_odd = data; }
		void setCaptureEvenEnabled(bool data) { _address->capture_even = data; }
		void setCaptureVBIOddEnabled(bool data)  { _address->capture_vbi_odd = data; }
		void setCaptureVBIEvenEnabled(bool data) { _address->capture_vbi_even = data; }
		void setCaptureEnabled(bool data) { _address->capture_even = _address->capture_odd = data; }
		void setCaptureVBIEnabled(bool data) { _address->capture_vbi_even = _address->capture_vbi_odd = data; }
		void setFifoEnabled(bool data) { _address->fifo_enable = data; }
		void setRiscEnabled(bool data) { _address->risc_enable = data; }
		void setDropFields(bool data) { _address->dec_field = data; }
		void setDropEvenField(bool data) { _address->dec_fieldalign = data; }
		void setDropRate(int data)
		{
			if (isDropFields())
				data <<= 1;
			_address->dec_rate = data;
		}

		bool isGamma(void) { return(_address->gamma); }
		bool isAGCFunction(void) { return(_address->agc_en); }
		bool isAdaptiveAGC(void) { return(_address->crush == 0); }
		bool isLowColorAutoRemoval(void) { return(_address->o_ckill); }
		bool isCbFirst(void) { return(_address->o_cbsense); }
		bool isChromaAGC(void) { return(_address->o_cagc); }
		bool isChromaComb(void) { return(_address->o_comb); }
		bool isChromaADC(void) { return(_address->c_sleep == 0); }
		bool isChromaOverflow(void) { return(_address->cof); }
		bool isLumaOverflow(void) { return(_address->lof); }
		bool isLumaADC(void) { return(_address->y_sleep == 0); }
		bool isExtFrame(void) { return(_address->ext_frame); }
		bool isLumaNotchFilter(void) { return(_address->o_lnotch); }
		bool isLumaPeakFilter(void) { return(_address->o_peak); }
		bool isLumaDecimation(void) { return(_address->o_ldec); }
		void setGamma(bool data) { _address->gamma = data; }
		void setAGCFunction(bool data) { _address->agc_en = data; }
		void setAdaptiveAGC(bool data) { _address->crush = (1 - data); }
		void setLowColorAutoRemoval(bool data) { _address->e_ckill = _address->o_ckill = data; }
		void setCbFirst(bool data) { _address->e_cbsense = _address->o_cbsense = data; }
		void setChromaAGC(bool data) { _address->e_cagc = _address->o_cagc = data; }
		void setChromaComb(bool data) { _address->e_comb = _address->o_comb = data; }
		void setChromaADC(bool data) { _address->c_sleep = (1 - data); }
		void resetChromaOverflow(void) { _address->cof = 0; }
		void resetLumaOverflow(void) { _address->lof = 0; }
		void setLumaADC(bool data) { _address->y_sleep = (1 - data); }
		void setExtFrame(bool data) { _address->ext_frame = data; }
		void setLumaNotchFilter(bool data) { _address->e_lnotch = _address->o_lnotch = data; }
		void setLumaPeakFilter(bool data) { _address->e_peak = _address->o_peak = data; }
		void setLumaDecimation(bool data) { _address->e_ldec = _address->o_ldec = data; }

		int getColorFormat(void) { return (_address->color_odd); }
		int getCoringLevel(void) {	return (_address->core); }
		bool isFullOutputRange(void) { return(_address->range); }
		bool isColorBars(void) { return(_address->color_bars); }
		bool isByteSwap(void) { return(_address->bswap_odd); }
		bool isWordSwap(void) { return(_address->wswap_odd); }
		void setColorFormat(int data)
      	{ _address->color_even = _address->color_odd = data; }
		void setCoringLevel(int data) { _address->core = data; }
		void setFullOutputRange(bool data) { _address->range = data; }
		void setColorBars(bool data) { _address->color_bars = data; }
		void setByteSwap(bool data)
        { _address->bswap_even = _address->bswap_odd = data; }
		void setWordSwap(bool data)
        { _address->wswap_even = _address->wswap_odd = data; }

		int getRiscIPC(void) { return(_address->risc_ipc); }
		int getRiscPC(void) { return(_address->risc_pc); }
		void setRiscIPC(int data) { _address->risc_ipc = data; }
		void setRiscPC(int data) { _address->risc_pc = data; }
      
      void scalerInit(void);		// initialize scaler, read HW settings
		void doScale(void);			// update all scaler registers
		void getAnalogWindow(int *, int *, int *, int * );	// analog : H/V active, delay window
		void getFieldSize( int *, int * );					// digital/analog scale
		int getHFilter(void);		// horizontal low-pass filter type
		int getVFilter(void);		// filter to remove junk lines from top of video
		void setAnalogWindow( int, int, int, int );
		void setFieldSize(int width, int height);
		void setHFilter( int );
		void setVFilter( int );

      void setAudioSource(int audio_type,int offset);
      int getAudioSource(void);

      int getGPOE(void);
		int getGPData(int frombit, int tobit, int offset);
      void setGPOE(int data);
		void setGPData(int frombit, int tobit, int value, int offset);

      void Write(int nRegister, unsigned int nValue);
		unsigned char Read(int nRegister);

		void i2cInit();	 		// initialize I2C
		void i2cStart();	 		// signal 'START'
		void i2cStop();	 		// signal 'STOP'
		void i2cWrite(unsigned char v); 	// write byte
		unsigned char i2cRead();		 	// read byte
		void i2cSendNACK();	 	// send 'NACK'
		void i2cSetSDA( int );	// set data
		void i2cSetSCL( int );	// set clock
		void i2cBitDelay();	 	// I2C wait (~50KHz)
		void i2cWaitForACK(); 	// wait for 'ACK'

      unsigned char readRemoteControl(char* debugbuf=0);

	private:
     	void detect_BT_membase(void);
      int openTvichw32(void);

    	int _type;
   	BTxxx_memmap* _address;
      unsigned int _nAdresse;

		int _hdelay;				// cached HDELAY value
		int _hactive;				// cached HACTIVE value
		int _field_height;		// digital height in scanlines

      I2C_t		_i2cShadow;
};


__int64 getMicroSec(void);


class AbstractTvTuner
{
	public:
   	AbstractTvTuner(BTxxx* bt)
      {
      	_bt = bt;
         _channel = -1;			// Init
      }
      virtual ~AbstractTvTuner()  { }

      virtual void setChannel(int channel)
      {
      	_channel = channel;
      }
      virtual int  getChannel(void)
      {
      	return(_channel);
      }

	private:
   	BTxxx*	_bt;				// Via _bt doen we aan I2C
      int 		_channel;
};

#endif
